package top.lshaci.framework.file.fdfs.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * FileFdfsErrorCode
 *
 * <p>1.1.0</p>
 * <pre>
 *     1.添加获取访问令牌异常
 * </pre>
 *
 * @author lshaci
 * @since 1.0.9
 * @version 1.1.0
 */
@Getter
@AllArgsConstructor
public enum FileFdfsErrorInfo implements ErrorInfo {

    /**
     * Fetch tracker server failed.
     */
    fetch_tracker_server_failed(506_1_01, "获取FastDfs服务器失败"),
    /**
     * Fastdfs file server connection failed.
     */
    file_server_connection_failed(506_1_02, "文件服务器连接失败"),
    /**
     * File deletion failed.
     */
    file_delete_failed(506_1_03, "删除文件失败"),

    /**
     * Fetch token failed.
     */
    fetch_token_failed(506_1_04, "获取访问令牌失败"),
    ;

    /**
     * 异常码
     */
    private final int code;
    /**
     * 异常信息
     */
    private final String msg;

}
