package top.lshaci.framework.file.fdfs.factory;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;

/**
 * <p>TrackerServerFactory</p>
 *
 *
 * @author lshaci
 * @since 1.0.9
 */
public class TrackerServerFactory extends BasePooledObjectFactory<TrackerServer>{

	@Override
	public TrackerServer create() throws Exception {
        return new TrackerClient().getConnection();
	}

	@Override
	public PooledObject<TrackerServer> wrap(TrackerServer trackerServer) {
		return new DefaultPooledObject<>(trackerServer);
	}

}
