package top.lshaci.framework.file.fdfs.properties;

import cn.hutool.core.map.MapUtil;
import lombok.Data;
import org.hibernate.validator.constraints.Range;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * FrameworkFdfsProperties
 *
 * @author lshaci
 * @since 1.0.9
 */
@Data
@Validated
@ConfigurationProperties(FrameworkFdfsProperties.PREFIX)
public class FrameworkFdfsProperties {

    /**
     * 配置前缀
     */
    public static final String PREFIX = "framework.fdfs";

    /**
     * 是否开启 fastdfs 配置
     */
    private boolean enabled = true;
    /**
     * nginx 反向代理地址
     */
    private String reverseProxyAddress;
    /**
     * fastdfs tracker server 线程池最小活动连接数
     */
    @Range(min = 2, max = 5)
    private int minIdle = 2;
    /**
     * fastdfs tracker server 线程池最大活动连接数
     */
    @Range(min = 8, max = 20)
    private int maxIdle = 8;
    /**
     * fastdfs tracker server 线程池总连接数
     */
    @Range(min = 8, max = 20)
    private int maxTotal = 8;
    /**
     * fastdfs 属性
     */
    private Map<String, String> properties = new HashMap<>();

    /**
     * 获取 fastdfs 配置
     *
     * @return fastdfs 配置
     */
    public Properties getFdfsProperties() {
        Properties fdfsProperties = new Properties();
        if (MapUtil.isNotEmpty(properties)) {
            properties.forEach((k, v) -> fdfsProperties.put("fastdfs." + k, v));
        }
        return fdfsProperties;
    }
}
