package top.lshaci.framework.file.fdfs.service;

import top.lshaci.framework.file.service.FileOperateService;

/**
 * <p>FdfsFileOperateService</p>
 *
 * <p>1.1.0</p>
 * <pre>
 *     1.添加获取访问令牌的方法
 * </pre>
 *
 * @author lshaci
 * @since 1.0.9
 * @version 1.1.0
 */
public interface FdfsFileOperateService extends FileOperateService {

    /**
     * 根据文件路径获取token
     *
     * <pre>
     *     返回示例: token=078d370098b03e9020b82c829c205e1f&amp;ts=1508141521
     * </pre>
     *
     * @param path 文件路径
     * @return token
     */
    String getToken(String path);

}
