/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.fdfs.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.file.fdfs.pool.TrackerServerPool;
import top.lshaci.framework.file.fdfs.properties.FrameworkFdfsProperties;
import top.lshaci.framework.file.fdfs.service.FdfsFileOperateService;
import top.lshaci.framework.file.fdfs.service.impl.FdfsFileOperateServiceImpl;
import top.lshaci.framework.file.properties.FrameworkFileProperties;

@Configuration
@ConditionalOnProperty(value={"framework.fdfs.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={FrameworkFileProperties.class, FrameworkFdfsProperties.class})
public class FrameworkFdfsConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkFdfsConfig.class);
    private final FrameworkFdfsProperties frameworkFdfsProperties;
    private final FrameworkFileProperties frameworkFileProperties;

    @Bean
    @ConditionalOnMissingBean
    public TrackerServerPool trackerServerPool() throws Exception {
        log.debug("Config fast dfs tracker server pool.");
        return new TrackerServerPool(this.frameworkFdfsProperties);
    }

    @Bean
    public FdfsFileOperateService fdfsFileOperateService() throws Exception {
        log.debug("Config fastdfs file upload service, Max file size: {}...", (Object)this.frameworkFileProperties.getMaxSize());
        return new FdfsFileOperateServiceImpl(this.frameworkFileProperties.getMaxSize(), this.trackerServerPool());
    }

    public FrameworkFdfsConfig(FrameworkFdfsProperties frameworkFdfsProperties, FrameworkFileProperties frameworkFileProperties) {
        this.frameworkFdfsProperties = frameworkFdfsProperties;
        this.frameworkFileProperties = frameworkFileProperties;
    }
}

