/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.fdfs.pool;

import java.util.Properties;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.file.fdfs.enums.FileFdfsErrorInfo;
import top.lshaci.framework.file.fdfs.exception.FileFdfsException;
import top.lshaci.framework.file.fdfs.factory.TrackerServerFactory;
import top.lshaci.framework.file.fdfs.properties.FrameworkFdfsProperties;

public class TrackerServerPool {
    private static final Logger log = LoggerFactory.getLogger(TrackerServerPool.class);
    private final GenericObjectPool<TrackerServer> trackerServerPool;

    public TrackerServerPool(FrameworkFdfsProperties properties) throws Exception {
        ClientGlobal.initByProperties((Properties)properties.getFdfsProperties());
        log.debug("ClientGlobal configInfo: \n{}", (Object)ClientGlobal.configInfo());
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMinIdle(properties.getMinIdle());
        poolConfig.setMaxIdle(properties.getMaxIdle());
        poolConfig.setMaxTotal(properties.getMinIdle());
        this.trackerServerPool = new GenericObjectPool((PooledObjectFactory)new TrackerServerFactory(), poolConfig);
    }

    public TrackerServer borrowObject() {
        try {
            return (TrackerServer)this.trackerServerPool.borrowObject();
        }
        catch (Exception e) {
            log.error(FileFdfsErrorInfo.fetch_tracker_server_failed.getMsg(), (Throwable)e);
            throw new FileFdfsException(FileFdfsErrorInfo.fetch_tracker_server_failed, new Object[0]);
        }
    }

    public void returnObject(TrackerServer trackerServer) {
        if (trackerServer != null) {
            this.trackerServerPool.returnObject((Object)trackerServer);
        }
    }
}

