/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.fdfs.properties;

import cn.hutool.core.map.MapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.validator.constraints.Range;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="framework.fdfs")
public class FrameworkFdfsProperties {
    public static final String PREFIX = "framework.fdfs";
    private boolean enabled = true;
    private String reverseProxyAddress;
    @Range(min=2L, max=5L)
    private @Range(min=2L, max=5L) int minIdle = 2;
    @Range(min=8L, max=20L)
    private @Range(min=8L, max=20L) int maxIdle = 8;
    @Range(min=8L, max=20L)
    private @Range(min=8L, max=20L) int maxTotal = 8;
    private Map<String, String> properties = new HashMap<String, String>();

    public Properties getFdfsProperties() {
        Properties fdfsProperties = new Properties();
        if (MapUtil.isNotEmpty(this.properties)) {
            this.properties.forEach((k, v) -> fdfsProperties.put("fastdfs." + k, v));
        }
        return fdfsProperties;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getReverseProxyAddress() {
        return this.reverseProxyAddress;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReverseProxyAddress(String reverseProxyAddress) {
        this.reverseProxyAddress = reverseProxyAddress;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrameworkFdfsProperties)) {
            return false;
        }
        FrameworkFdfsProperties other = (FrameworkFdfsProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$reverseProxyAddress = this.getReverseProxyAddress();
        String other$reverseProxyAddress = other.getReverseProxyAddress();
        if (this$reverseProxyAddress == null ? other$reverseProxyAddress != null : !this$reverseProxyAddress.equals(other$reverseProxyAddress)) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        if (this.getMaxIdle() != other.getMaxIdle()) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrameworkFdfsProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $reverseProxyAddress = this.getReverseProxyAddress();
        result = result * 59 + ($reverseProxyAddress == null ? 43 : $reverseProxyAddress.hashCode());
        result = result * 59 + this.getMinIdle();
        result = result * 59 + this.getMaxIdle();
        result = result * 59 + this.getMaxTotal();
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "FrameworkFdfsProperties(enabled=" + this.isEnabled() + ", reverseProxyAddress=" + this.getReverseProxyAddress() + ", minIdle=" + this.getMinIdle() + ", maxIdle=" + this.getMaxIdle() + ", maxTotal=" + this.getMaxTotal() + ", properties=" + this.getProperties() + ")";
    }
}

