/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.fdfs.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import org.csource.common.MyException;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;
import top.lshaci.framework.common.constants.ErrorInfo;
import top.lshaci.framework.file.enums.FileErrorInfo;
import top.lshaci.framework.file.exception.FileDownloadException;
import top.lshaci.framework.file.exception.FileOperateException;
import top.lshaci.framework.file.exception.FileUploadException;
import top.lshaci.framework.file.fdfs.enums.FileFdfsErrorInfo;
import top.lshaci.framework.file.fdfs.exception.FileFdfsException;
import top.lshaci.framework.file.fdfs.pool.TrackerServerPool;
import top.lshaci.framework.file.fdfs.service.FdfsFileOperateService;

public class FdfsFileOperateServiceImpl
implements FdfsFileOperateService {
    private static final Logger log = LoggerFactory.getLogger(FdfsFileOperateServiceImpl.class);
    private final DataSize maxSize;
    private final TrackerServerPool trackerServerPool;

    public String upload(InputStream inputStream, String extName) throws IOException {
        int available = inputStream.available();
        if (available <= 0) {
            throw new FileUploadException(FileErrorInfo.size_is_empty, new Object[0]);
        }
        log.debug("Upload size: {}, Max size: {}", (Object)available, (Object)this.maxSize);
        if ((long)available > this.maxSize.toBytes()) {
            throw new FileUploadException(FileErrorInfo.exceed_limit, new Object[0]);
        }
        TrackerServer trackerServer = null;
        try {
            trackerServer = this.trackerServerPool.borrowObject();
            StorageClient1 storageClient = new StorageClient1(trackerServer, null);
            byte[] fileBuff = new byte[inputStream.available()];
            inputStream.read(fileBuff, 0, fileBuff.length);
            String path = storageClient.upload_file1(fileBuff, extName, null);
            if (StrUtil.isBlank((CharSequence)path)) {
                throw new FileUploadException(FileErrorInfo.upload_failed, new Object[0]);
            }
            log.debug("Upload success, Path is: {}", (Object)path);
            String string = path;
            return string;
        }
        catch (MyException e) {
            log.error(FileFdfsErrorInfo.file_server_connection_failed.getMsg(), (Throwable)e);
            throw new FileFdfsException(FileFdfsErrorInfo.file_server_connection_failed, new Object[0]);
        }
        finally {
            this.trackerServerPool.returnObject(trackerServer);
        }
    }

    public void delete(List<String> pathList) {
        if (CollUtil.isEmpty(pathList)) {
            log.warn("\u672a\u6307\u5b9a\u9700\u8981\u5220\u9664\u7684\u6587\u4ef6");
            return;
        }
        TrackerServer trackerServer = this.trackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        try {
            for (String path : pathList) {
                log.info("\u4eceFastDfs\u4e2d\u5220\u9664\u6587\u4ef6: Path: {}", (Object)path);
                storageClient.delete_file1(path);
            }
        }
        catch (IOException | MyException e) {
            log.error(FileFdfsErrorInfo.file_delete_failed.getMsg(), e);
            throw new FileFdfsException(FileFdfsErrorInfo.file_delete_failed, new Object[0]);
        }
        finally {
            this.trackerServerPool.returnObject(trackerServer);
        }
    }

    public void write(String path, OutputStream outputStream) {
        TrackerServer trackerServer = this.trackerServerPool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        if (StrUtil.isBlank((CharSequence)path)) {
            throw new FileOperateException((ErrorInfo)FileErrorInfo.path_is_blank, new Object[0]);
        }
        try {
            byte[] fileByte = storageClient.download_file1(path);
            if (ArrayUtil.isEmpty((byte[])fileByte)) {
                log.error(FileErrorInfo.not_exist.getMsg() + ": {}", (Object)path);
                throw new FileDownloadException(FileErrorInfo.not_exist, new Object[0]);
            }
            IoUtil.write((OutputStream)outputStream, (boolean)false, (byte[])fileByte);
        }
        catch (IOException | MyException e) {
            log.error(FileErrorInfo.fetch_failed.getMsg() + ": {}", (Object)path);
            throw new FileDownloadException(FileErrorInfo.fetch_failed, new Object[0]);
        }
        finally {
            this.trackerServerPool.returnObject(trackerServer);
        }
    }

    @Override
    public String getToken(String path) {
        try {
            int ts = (int)Instant.now().getEpochSecond();
            String token = ProtoCommon.getToken((String)this.getFilename(path), (int)ts, (String)ClientGlobal.getG_secret_key());
            return StrUtil.format((CharSequence)"token={}&ts={}", (Object[])new Object[]{token, ts});
        }
        catch (Exception e) {
            log.error(FileFdfsErrorInfo.fetch_token_failed.getMsg() + ": {}", (Object)path);
            throw new FileFdfsException(FileFdfsErrorInfo.fetch_token_failed, new Object[0]);
        }
    }

    private String getFilename(String path) {
        String[] results = new String[2];
        StorageClient1.split_file_id((String)path, (String[])results);
        return results[1];
    }

    public FdfsFileOperateServiceImpl(DataSize maxSize, TrackerServerPool trackerServerPool) {
        this.maxSize = maxSize;
        this.trackerServerPool = trackerServerPool;
    }
}

