package top.lshaci.framework.file.minio.config;

import io.minio.MinioClient;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.file.minio.properties.FrameworkMinioProperties;
import top.lshaci.framework.file.minio.service.MinioFileOperateService;
import top.lshaci.framework.file.minio.service.impl.MinioFileOperateServiceImpl;
import top.lshaci.framework.file.properties.FrameworkFileProperties;

/**
 * FrameworkMinioConfig
 *
 * @author lshaci
 * @since 1.1.0
 */
@Slf4j
@Configuration
@AllArgsConstructor
@ConditionalOnProperty(value = "framework.minio.enabled", matchIfMissing = true)
@EnableConfigurationProperties({FrameworkFileProperties.class, FrameworkMinioProperties.class})
public class FrameworkMinioConfig {

    private final FrameworkMinioProperties minioProperties;

    private final FrameworkFileProperties fileProperties;

    /**
     * 配置 min io 客户端
     *
     * @return min io 客户端
     */
    @Bean
    @ConditionalOnMissingBean
    public MinioClient minioClient() {
        log.debug("Config min io client...");

        return MinioClient.builder()
                .endpoint(minioProperties.getEndpoint())
                .credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey())
                .build();
    }

    /**
     * 配置文件操作业务类
     *
     * @return 文件操作业务类
     */
    @Bean
    public MinioFileOperateService minioFileOperateService() {
        log.debug("Config min io file upload service, Max file size: {}...", fileProperties.getMaxSize());
        return new MinioFileOperateServiceImpl(minioClient(),
                minioProperties.getExpiry(),
                minioProperties.getBucket(),
                fileProperties.getMaxSize()
        );
    }

}
