package top.lshaci.framework.file.minio.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * FileOssErrorInfo
 *
 * @author lshaci
 * @since 1.1.0
 */
@Getter
@AllArgsConstructor
public enum FileMinioErrorInfo implements ErrorInfo {

    /**
     * The bucket is blank.
     */
    bucket_is_blank(506_2_01, "文件存储模块为空"),
    /**
     * bucket create failure
     */
    bucket_create_failure(506_3_02, "创建文件存储目录失败"),
    /**
     * presigned url fetch failure
     */
    presigned_url_fetch_failure(506_3_03, "预签名地址获取失败"),
    ;

    /**
     * 异常码
     */
    private final int code;
    /**
     * 异常信息
     */
    private final String msg;

}
