package top.lshaci.framework.file.minio.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;
import java.time.Duration;

/**
 * FrameworkMinioProperties
 *
 * @author lshaci
 * @since 1.1.0
 */
@Data
@Validated
@ConfigurationProperties(FrameworkMinioProperties.PREFIX)
public class FrameworkMinioProperties {

    /**
     * 配置前缀
     */
    public static final String PREFIX = "framework.minio";

    /**
     * 开启 minio 配置
     */
    private boolean enabled = true;
    /**
     * 默认 存储文件的 bucket
     */
    @NotBlank
    private String bucket;
    /**
     * endpoint
     */
    @NotBlank
    private String endpoint;
    /**
     * accessKey
     */
    @NotBlank
    private String accessKey;
    /**
     * secretKey
     */
    @NotBlank
    private String secretKey;

    /**
     * expiry
     */
    private Duration expiry = Duration.ofDays(7);

}
