/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.minio.config;

import io.minio.MinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.file.minio.properties.FrameworkMinioProperties;
import top.lshaci.framework.file.minio.service.MinioFileOperateService;
import top.lshaci.framework.file.minio.service.impl.MinioFileOperateServiceImpl;
import top.lshaci.framework.file.properties.FrameworkFileProperties;

@Configuration
@ConditionalOnProperty(value={"framework.minio.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={FrameworkFileProperties.class, FrameworkMinioProperties.class})
public class FrameworkMinioConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkMinioConfig.class);
    private final FrameworkMinioProperties minioProperties;
    private final FrameworkFileProperties fileProperties;

    @Bean
    @ConditionalOnMissingBean
    public MinioClient minioClient() {
        log.debug("Config min io client...");
        return MinioClient.builder().endpoint(this.minioProperties.getEndpoint()).credentials(this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey()).build();
    }

    @Bean
    public MinioFileOperateService minioFileOperateService() {
        log.debug("Config min io file upload service, Max file size: {}...", (Object)this.fileProperties.getMaxSize());
        return new MinioFileOperateServiceImpl(this.minioClient(), this.minioProperties.getExpiry(), this.minioProperties.getBucket(), this.fileProperties.getMaxSize());
    }

    public FrameworkMinioConfig(FrameworkMinioProperties minioProperties, FrameworkFileProperties fileProperties) {
        this.minioProperties = minioProperties;
        this.fileProperties = fileProperties;
    }
}

