/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.minio.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import io.minio.GetObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.http.Method;
import io.minio.messages.DeleteObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import top.lshaci.framework.file.service.FileOperateService;

public interface MinioFileOperateService
extends FileOperateService {
    public String bucket();

    default public String upload(InputStream inputStream, String extName) throws IOException {
        return this.single(inputStream, this.bucket(), () -> StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{IdUtil.objectId(), ".", extName}));
    }

    default public String single(InputStream inputStream, Supplier<String> pathSupplier) throws IOException {
        return this.single(inputStream, this.bucket(), pathSupplier);
    }

    public String single(InputStream var1, String var2, Supplier<String> var3) throws IOException;

    default public void delete(String name) {
        this.delete(this.bucket(), name);
    }

    default public void delete(List<String> names) {
        this.delete(this.bucket(), names);
    }

    default public void delete(String bucket, String name) {
        this.delete(bucket, CollUtil.newArrayList((Object[])new String[]{name}));
    }

    default public void delete(String bucket, List<String> names) {
        if (CollUtil.isEmpty(names)) {
            return;
        }
        List deleteObjects = names.stream().map(DeleteObject::new).collect(Collectors.toList());
        RemoveObjectsArgs args = (RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucket)).objects(deleteObjects).build();
        this.delete(args);
    }

    public void delete(RemoveObjectsArgs var1);

    default public void write(String name, OutputStream outputStream) {
        this.write(this.bucket(), name, outputStream);
    }

    default public void write(String bucket, String name, OutputStream outputStream) {
        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(name)).build();
        this.write(args, outputStream);
    }

    public void write(GetObjectArgs var1, OutputStream var2);

    public String presignedUrl(String var1, String var2, Method var3, Duration var4);

    default public String getPresignedUrl(String name) {
        return this.presignedUrl(this.bucket(), name, Method.GET, null);
    }
}

