/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.minio.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.errors.MinioException;
import io.minio.http.Method;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;
import top.lshaci.framework.common.constants.ErrorInfo;
import top.lshaci.framework.file.enums.FileErrorInfo;
import top.lshaci.framework.file.exception.FileDownloadException;
import top.lshaci.framework.file.exception.FileOperateException;
import top.lshaci.framework.file.exception.FileUploadException;
import top.lshaci.framework.file.minio.enums.FileMinioErrorInfo;
import top.lshaci.framework.file.minio.exception.FileMinioException;
import top.lshaci.framework.file.minio.service.MinioFileOperateService;

public class MinioFileOperateServiceImpl
implements MinioFileOperateService {
    private static final Logger log = LoggerFactory.getLogger(MinioFileOperateServiceImpl.class);
    private final MinioClient minioClient;
    private final Duration defaultExpiry;
    private final String defaultBucket;
    private final DataSize maxSize;

    @Override
    public String single(InputStream inputStream, String bucket, Supplier<String> pathSupplier) throws IOException {
        int available = inputStream.available();
        if (available <= 0) {
            throw new FileUploadException(FileErrorInfo.size_is_empty, new Object[0]);
        }
        log.debug("Upload size: {}, Max size: {}", (Object)available, (Object)this.maxSize);
        if ((long)available > this.maxSize.toBytes()) {
            throw new FileUploadException(FileErrorInfo.exceed_limit, new Object[0]);
        }
        String name = pathSupplier.get();
        this.verifyBucketAndName(bucket, name);
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(name)).stream(inputStream, (long)inputStream.available(), -1L).build());
        }
        catch (MinioException | GeneralSecurityException e) {
            log.error(FileErrorInfo.upload_failed.getMsg(), e);
            throw new FileUploadException(FileErrorInfo.upload_failed, new Object[0]);
        }
        log.debug("Upload success, Object name is: {}", (Object)name);
        return name;
    }

    @Override
    public void delete(RemoveObjectsArgs args) {
        Iterable deleteObjects = args.objects();
        if (CollUtil.isEmpty((Iterable)deleteObjects)) {
            log.warn("\u672a\u6307\u5b9a\u9700\u8981\u5220\u9664\u7684\u6587\u4ef6");
            return;
        }
        this.verifyBucket(args.bucket());
        this.minioClient.removeObjects(args);
    }

    @Override
    public void write(GetObjectArgs args, OutputStream outputStream) {
        this.verifyBucketAndName(args.bucket(), args.object());
        try {
            GetObjectResponse object = this.minioClient.getObject(args);
            IoUtil.copy((InputStream)object, (OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error(FileErrorInfo.fetch_failed.getMsg(), (Throwable)e);
            throw new FileDownloadException(FileErrorInfo.fetch_failed, new Object[0]);
        }
    }

    @Override
    public String presignedUrl(String bucket, String name, Method method, Duration expiry) {
        this.verifyBucketAndName(bucket, name);
        try {
            return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucket)).object(name)).method(Optional.ofNullable(method).orElse(Method.GET)).expiry((int)Optional.ofNullable(expiry).orElse(this.defaultExpiry).getSeconds()).build());
        }
        catch (MinioException | IOException | GeneralSecurityException e) {
            log.error(FileMinioErrorInfo.presigned_url_fetch_failure.getMsg(), e);
            throw new FileMinioException(FileMinioErrorInfo.presigned_url_fetch_failure, new Object[0]);
        }
    }

    @Override
    public String bucket() {
        return this.defaultBucket;
    }

    private void verifyBucket(String bucket) {
        if (StrUtil.isBlank((CharSequence)bucket)) {
            throw new FileMinioException(FileMinioErrorInfo.bucket_is_blank, new Object[0]);
        }
        try {
            boolean bucketExists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build());
            if (!bucketExists) {
                this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
            }
        }
        catch (MinioException | IOException | GeneralSecurityException e) {
            log.error(FileMinioErrorInfo.bucket_create_failure.getMsg(), e);
            throw new FileMinioException(FileMinioErrorInfo.bucket_create_failure, new Object[0]);
        }
    }

    private void verifyName(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            throw new FileOperateException((ErrorInfo)FileErrorInfo.path_is_blank, new Object[0]);
        }
    }

    private void verifyBucketAndName(String bucket, String name) {
        this.verifyName(name);
        this.verifyBucket(bucket);
    }

    public MinioFileOperateServiceImpl(MinioClient minioClient, Duration defaultExpiry, String defaultBucket, DataSize maxSize) {
        this.minioClient = minioClient;
        this.defaultExpiry = defaultExpiry;
        this.defaultBucket = defaultBucket;
        this.maxSize = maxSize;
    }
}

