package top.lshaci.framework.file.oss.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * FileOssErrorInfo
 *
 * @author lshaci
 * @since 1.0.9
 */
@Getter
@AllArgsConstructor
public enum FileOssErrorInfo implements ErrorInfo {

    /**
     * The bucket is blank.
     */
    bucket_is_blank(506_2_01, "文件存储模块为空"),
    ;

    /**
     * 异常码
     */
    private final int code;
    /**
     * 异常信息
     */
    private final String msg;

}
