/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.oss.config;

import com.alibaba.alicloud.context.AliCloudProperties;
import com.alibaba.alicloud.context.oss.OssProperties;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSEncryptionClient;
import com.aliyun.oss.OSSEncryptionClientBuilder;
import com.aliyun.oss.crypto.EncryptionMaterials;
import com.aliyun.oss.crypto.SimpleRSAEncryptionMaterials;
import java.security.KeyPair;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.file.oss.properties.FrameworkOssProperties;
import top.lshaci.framework.file.oss.service.OssFileOperateService;
import top.lshaci.framework.file.oss.service.impl.OssFileOperateServiceImpl;
import top.lshaci.framework.file.properties.FrameworkFileProperties;

@Configuration
@ConditionalOnProperty(value={"framework.oss.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={FrameworkFileProperties.class, FrameworkOssProperties.class})
public class FrameworkOssConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkOssConfig.class);
    private final OssProperties ossProperties;
    private final AliCloudProperties aliCloudProperties;
    private final FrameworkOssProperties frameworkOssProperties;
    private final FrameworkFileProperties frameworkFileProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.oss.encryption.enabled"})
    public OSSEncryptionClient ossEncryptionClient() {
        log.debug("Config oss encryption client...");
        String endpoint = this.ossProperties.getEndpoint();
        String accessKeyId = this.aliCloudProperties.getAccessKey();
        String accessKeySecret = this.aliCloudProperties.getSecretKey();
        KeyPair keyPair = this.frameworkOssProperties.getEncryption().keyPair();
        SimpleRSAEncryptionMaterials encryptionMaterials = new SimpleRSAEncryptionMaterials(keyPair);
        return new OSSEncryptionClientBuilder().build(endpoint, accessKeyId, accessKeySecret, (EncryptionMaterials)encryptionMaterials);
    }

    @Bean
    public OssFileOperateService ossFileOperateService(@Autowired(required=false) @Qualifier(value="ossClient") OSS ossClient, @Autowired(required=false) @Qualifier(value="ossEncryptionClient") OSS ossEncryptionClient) {
        OSS oss = Optional.ofNullable(ossEncryptionClient).orElse(ossClient);
        assert (oss != null);
        log.debug("Config oss file upload service, OSS client: {}, Max file size: {}...", oss.getClass(), (Object)this.frameworkFileProperties.getMaxSize());
        return new OssFileOperateServiceImpl(oss, this.frameworkOssProperties.getBucket(), this.frameworkFileProperties.getMaxSize());
    }

    public FrameworkOssConfig(OssProperties ossProperties, AliCloudProperties aliCloudProperties, FrameworkOssProperties frameworkOssProperties, FrameworkFileProperties frameworkFileProperties) {
        this.ossProperties = ossProperties;
        this.aliCloudProperties = aliCloudProperties;
        this.frameworkOssProperties = frameworkOssProperties;
        this.frameworkFileProperties = frameworkFileProperties;
    }
}

