/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.oss.properties;

import com.aliyun.oss.crypto.SimpleRSAEncryptionMaterials;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="framework.oss")
public class FrameworkOssProperties {
    public static final String PREFIX = "framework.oss";
    private boolean enabled = true;
    @NotBlank
    private String bucket;
    @Valid
    private Encryption encryption = new Encryption();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrameworkOssProperties)) {
            return false;
        }
        FrameworkOssProperties other = (FrameworkOssProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        Encryption this$encryption = this.getEncryption();
        Encryption other$encryption = other.getEncryption();
        return !(this$encryption == null ? other$encryption != null : !((Object)this$encryption).equals(other$encryption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrameworkOssProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        Encryption $encryption = this.getEncryption();
        result = result * 59 + ($encryption == null ? 43 : ((Object)$encryption).hashCode());
        return result;
    }

    public String toString() {
        return "FrameworkOssProperties(enabled=" + this.isEnabled() + ", bucket=" + this.getBucket() + ", encryption=" + this.getEncryption() + ")";
    }

    public class Encryption {
        private boolean enabled = false;
        @NotBlank
        private String rsaPublicKey;
        @NotBlank
        private String rsaPrivateKey;

        public KeyPair keyPair() {
            RSAPrivateKey privateKey = SimpleRSAEncryptionMaterials.getPrivateKeyFromPemPKCS1((String)this.rsaPrivateKey);
            RSAPublicKey publicKey = SimpleRSAEncryptionMaterials.getPublicKeyFromPemX509((String)this.rsaPublicKey);
            return new KeyPair(publicKey, privateKey);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getRsaPublicKey() {
            return this.rsaPublicKey;
        }

        public String getRsaPrivateKey() {
            return this.rsaPrivateKey;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setRsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
        }

        public void setRsaPrivateKey(String rsaPrivateKey) {
            this.rsaPrivateKey = rsaPrivateKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Encryption)) {
                return false;
            }
            Encryption other = (Encryption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$rsaPublicKey = this.getRsaPublicKey();
            String other$rsaPublicKey = other.getRsaPublicKey();
            if (this$rsaPublicKey == null ? other$rsaPublicKey != null : !this$rsaPublicKey.equals(other$rsaPublicKey)) {
                return false;
            }
            String this$rsaPrivateKey = this.getRsaPrivateKey();
            String other$rsaPrivateKey = other.getRsaPrivateKey();
            return !(this$rsaPrivateKey == null ? other$rsaPrivateKey != null : !this$rsaPrivateKey.equals(other$rsaPrivateKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Encryption;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $rsaPublicKey = this.getRsaPublicKey();
            result = result * 59 + ($rsaPublicKey == null ? 43 : $rsaPublicKey.hashCode());
            String $rsaPrivateKey = this.getRsaPrivateKey();
            result = result * 59 + ($rsaPrivateKey == null ? 43 : $rsaPrivateKey.hashCode());
            return result;
        }

        public String toString() {
            return "FrameworkOssProperties.Encryption(enabled=" + this.isEnabled() + ", rsaPublicKey=" + this.getRsaPublicKey() + ", rsaPrivateKey=" + this.getRsaPrivateKey() + ")";
        }
    }
}

