/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.oss.service;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Supplier;
import top.lshaci.framework.file.service.FileOperateService;

public interface OssFileOperateService
extends FileOperateService {
    public String bucket();

    default public String upload(InputStream inputStream, String extName) throws IOException {
        return this.single(inputStream, this.bucket(), () -> StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{IdUtil.objectId(), ".", extName}));
    }

    default public String single(InputStream inputStream, Supplier<String> pathSupplier) throws IOException {
        return this.single(inputStream, this.bucket(), pathSupplier);
    }

    public String single(InputStream var1, String var2, Supplier<String> var3) throws IOException;

    default public void delete(String path) {
        this.delete(this.bucket(), path);
    }

    default public void delete(List<String> pathList) {
        this.delete(this.bucket(), pathList);
    }

    public void delete(String var1, String var2);

    default public DeleteObjectsResult delete(String bucket, List<String> pathList) {
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucket);
        deleteObjectsRequest.setKeys(pathList);
        return this.delete(deleteObjectsRequest);
    }

    public DeleteObjectsResult delete(DeleteObjectsRequest var1);

    default public void write(String path, OutputStream outputStream) {
        this.write(this.bucket(), path, outputStream);
    }

    default public void write(String bucket, String path, OutputStream outputStream) {
        GetObjectRequest request = new GetObjectRequest(bucket, path);
        this.write(request, outputStream);
    }

    public void write(GetObjectRequest var1, OutputStream var2);
}

