/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.file.oss.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;
import top.lshaci.framework.common.constants.ErrorInfo;
import top.lshaci.framework.file.enums.FileErrorInfo;
import top.lshaci.framework.file.exception.FileDownloadException;
import top.lshaci.framework.file.exception.FileOperateException;
import top.lshaci.framework.file.exception.FileUploadException;
import top.lshaci.framework.file.oss.enums.FileOssErrorInfo;
import top.lshaci.framework.file.oss.exception.FileOssException;
import top.lshaci.framework.file.oss.service.OssFileOperateService;

public class OssFileOperateServiceImpl
implements OssFileOperateService {
    private static final Logger log = LoggerFactory.getLogger(OssFileOperateServiceImpl.class);
    private final OSS oss;
    private final String defaultBucket;
    private final DataSize maxSize;

    @Override
    public String single(InputStream inputStream, String bucket, Supplier<String> pathSupplier) throws IOException {
        this.verifyBucket(bucket);
        int available = inputStream.available();
        if (available <= 0) {
            throw new FileUploadException(FileErrorInfo.size_is_empty, new Object[0]);
        }
        log.debug("Upload size: {}, Max size: {}", (Object)available, (Object)this.maxSize);
        if ((long)available > this.maxSize.toBytes()) {
            throw new FileUploadException(FileErrorInfo.exceed_limit, new Object[0]);
        }
        String key = pathSupplier.get();
        this.verifyKey(key);
        this.oss.putObject(bucket, key, inputStream);
        log.debug("Upload success, Path is: {}", (Object)key);
        return key;
    }

    @Override
    public void delete(String bucket, String path) {
        this.verifyBucketAndKey(bucket, path);
        this.oss.deleteObject(bucket, path);
    }

    @Override
    public DeleteObjectsResult delete(DeleteObjectsRequest deleteObjectsRequest) {
        List keys = deleteObjectsRequest.getKeys();
        if (CollUtil.isEmpty((Collection)keys)) {
            log.warn("\u672a\u6307\u5b9a\u9700\u8981\u5220\u9664\u7684\u6587\u4ef6");
            return null;
        }
        this.verifyBucket(deleteObjectsRequest.getBucketName());
        return this.oss.deleteObjects(deleteObjectsRequest);
    }

    @Override
    public void write(GetObjectRequest request, OutputStream outputStream) {
        this.verifyBucketAndKey(request.getBucketName(), request.getKey());
        boolean exist = this.oss.doesObjectExist((GenericRequest)request);
        if (!exist) {
            log.error(FileErrorInfo.not_exist.getMsg() + "; bucket: {}, path: {}", (Object)request.getBucketName(), (Object)request.getKey());
            throw new FileDownloadException(FileErrorInfo.not_exist, new Object[0]);
        }
        OSSObject object = this.oss.getObject(request);
        InputStream objectContent = object.getObjectContent();
        IoUtil.copy((InputStream)objectContent, (OutputStream)outputStream);
    }

    @Override
    public String bucket() {
        return this.defaultBucket;
    }

    private void verifyBucket(String bucket) {
        if (StrUtil.isBlank((CharSequence)bucket)) {
            throw new FileOssException(FileOssErrorInfo.bucket_is_blank, new Object[0]);
        }
    }

    private void verifyKey(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            throw new FileOperateException((ErrorInfo)FileErrorInfo.path_is_blank, new Object[0]);
        }
    }

    private void verifyBucketAndKey(String bucket, String key) {
        this.verifyKey(key);
        this.verifyBucket(bucket);
    }

    public OssFileOperateServiceImpl(OSS oss, String defaultBucket, DataSize maxSize) {
        this.oss = oss;
        this.defaultBucket = defaultBucket;
        this.maxSize = maxSize;
    }
}

