package top.lshaci.framework.file.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * FileErrorInfo
 *
 * @author lshaci
 * @since 1.0.9
 */
@Getter
@AllArgsConstructor
public enum FileErrorInfo implements ErrorInfo {

    /**
     * The file size exceeds the limit.
     */
    exceed_limit(506_0_01, "文件大小超过限制"),
    /**
     * File uploading failed.
     */
    upload_failed(506_0_02, "上传文件失败"),
    /**
     * File fetch failed.
     */
    fetch_failed(506_0_03, "文件获取失败"),
    /**
     * The file path is blank.
     */
    path_is_blank(506_0_04, "文件路径为空"),
    	/**
	 * This file size is empty.
	 */
	size_is_empty(506_0_05, "文件大小为空"),
    /**
     * The file not exist.
     */
    not_exist(506_0_06, "文件不存在"),
    ;

    /**
     * 异常码
     */
    private final int code;
    /**
     * 异常信息
     */
    private final String msg;

}
