package top.lshaci.framework.file.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

import static top.lshaci.framework.file.properties.FrameworkFileProperties.PREFIX;

/**
 * FrameworkFileProperties
 *
 * @author lshaci
 * @since 1.0.9
 */
@Data
@Validated
@ConfigurationProperties(PREFIX)
public class FrameworkFileProperties {

    /**
     * 配置前缀
     */
    public static final String PREFIX = "framework.file";

    /**
     * 大小限制; 默认 1MB
     */
    private DataSize maxSize = DataSize.ofMegabytes(1);
}
