package top.lshaci.framework.file.service;

import java.util.Collections;
import java.util.List;

/**
 * FileDeleteService
 *
 * @author lshaci
 * @since 1.0.9
 */
public interface FileDeleteService {

    /**
     * 根据文件地址删除文件
     *
     * @param path 文件地址
     */
    default void delete(String path) {
        delete(Collections.singletonList(path));
    }

    /**
     * 根据文件地址集合删除多个文件
     *
     * @param pathList 文件地址集合
     */
    void delete(List<String> pathList);
}
