package top.lshaci.framework.file.service;

import cn.hutool.core.io.file.FileNameUtil;

import java.io.IOException;
import java.io.InputStream;

/**
 * FileUploadService
 *
 * @author lshaci
 * @since 1.0.9
 */
public interface FileUploadService {

    /**
     * 上传单个文件
     *
     * @param fileName    文件名
     * @param inputStream 文件的输入流
     * @return 文件存储空间中的地址
     * @throws IOException 如果产生 I/O 异常
     */
    default String upload(String fileName, InputStream inputStream) throws IOException {
        String extName = FileNameUtil.extName(fileName);
        return upload(inputStream, extName);
    }

    /**
     * 上传单个文件
     *
     * @param inputStream 文件的输入流
     * @param extName     文件扩展名(不含<b>.</b>)
     * @return 文件存储空间中的地址
     * @throws IOException 如果产生 I/O 异常
     */
    String upload(InputStream inputStream, String extName) throws IOException;
}
