package top.lshaci.framework.log.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Log</p>
 *
 * <pre>
 *     1.1.0: 添加 module 属性
 * </pre>
 *
 * @author lshaci
 * @since 1.0.9
 * @version 1.1.0
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Log {

    /**
     * 日志标题
     *
     * @return 标题
     */
    String title();

    /**
     * 日志模块
     *
     * @return 模块
     */
    String module() default "default";
}
