package top.lshaci.framework.log.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.log.aspect.LogAspect;
import top.lshaci.framework.log.service.LogService;
import top.lshaci.framework.log.service.impl.LoggingService;

/**
 * FrameworkConfig
 *
 * @author lshaci
 * @since 1.0.9
 */
@Slf4j
@Configuration
@ConditionalOnProperty(value = "framework.log.enabled", matchIfMissing = true)
public class FrameworkLogConfig implements BeanFactoryAware {

    private DefaultListableBeanFactory beanFactory;

    /**
     * 日志切面
     *
     * @return 日志切面
     */
    @Bean
    public LogAspect logAspect() {
        log.debug("Config log aspect...");
        return beanFactory.createBean(LogAspect.class);
    }

    /**
     * 日志记录业务类
     *
     * @return 日志记录业务类
     */
    @Bean
    @ConditionalOnMissingBean
    public LogService logService() {
        log.debug("Config logging service...");
        return new LoggingService();
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (DefaultListableBeanFactory) beanFactory;
    }
}
