package top.lshaci.framework.log.model;

import lombok.Data;
import lombok.experimental.Accessors;
import top.lshaci.framework.log.enums.OperateStatus;

/**
 * LogModel
 *
 * <pre>
 *     1.1.0: 添加 module 属性
 * </pre>
 *
 * @author lshaci
 * @since 1.1.0
 */
@Data
@Accessors(chain = true)
public class LogModel {

    /**
     * 目标类
     */
    private Class<?> targetClass;

    /**
     * 目标方法
     */
    private String targetMethod;

    /**
     * 参数
     */
    private Object[] args;

    /**
     * 操作状态
     */
    private OperateStatus status;

    /**
     * 模块
     */
    private String module;

    /**
     * 日志标题
     */
    private String title;

    /**
     * 异常消息
     */
    private String exceptionMessage;

    /**
     * 日志内容
     */
    private Object content;

    public <C> C getContent(Class<C> cls) {
        return (C) getContent();
    }
}
