package top.lshaci.framework.log.service.impl;

import lombok.extern.slf4j.Slf4j;
import top.lshaci.framework.log.enums.OperateStatus;
import top.lshaci.framework.log.model.LogModel;
import top.lshaci.framework.log.service.LogService;

/**
 * LoggingService
 *
 * <pre>
 *     1.1.0: 添加 module 属性
 * </pre>
 *
 * @author lshaci
 * @since 1.1.0
 */
@Slf4j
public class LoggingService implements LogService {

    @Override
    public void record(LogModel model) {
        OperateStatus status = model.getStatus();
        Object content = model.getContent();
        if (OperateStatus.failure.equals(status)) {
            log.warn("Execution failure ==> {}:{} - Module: {}, Title: {}, Content: {}, Exception message: {}.", model.getTargetClass().getName(), model.getTargetMethod(), model.getModule(), model.getTitle(), content, model.getExceptionMessage());
        } else if (OperateStatus.success.equals(status)) {
            log.debug("Execution success ==> {}:{} - Module: {}, Title: {}, Content: {}.", model.getTargetClass().getName(), model.getTargetMethod(), model.getModule(), model.getTitle(), content);
        }
    }
}
