package top.lshaci.framework.log.thread;

import org.springframework.core.NamedThreadLocal;

/**
 * LogThreadLocal
 *
 * @author lshaci
 * @since 1.0.9
 */
public class LogThreadLocal {

    private static ThreadLocal<Object> threadLocal = new NamedThreadLocal<>("framework-log");

    /**
     * 设置日志内容
     *
     * @param obj 日志内容
     */
    public static void set(Object obj) {
        threadLocal.set(obj);
    }

    /**
     * 获取日志内容
     *
     * @param cls 内容类型
     * @param <C> 内容类型
     * @return 日志内容
     */
    public static <C> C get(Class<C> cls) {
        return (C) threadLocal.get();
    }

    /**
     * 清空当前线程中的日志内容
     */
    public static void remove() {
        threadLocal.remove();
    }
}
