/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.log.aspect;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import top.lshaci.framework.log.enums.OperateStatus;
import top.lshaci.framework.log.model.LogModel;
import top.lshaci.framework.log.service.LogService;
import top.lshaci.framework.log.thread.LogThreadLocal;

@Aspect
@Order(value=2)
public class LogAspect {
    private static final Log logger = LogFactory.get(LogAspect.class);
    private final LogService logService;

    @Around(value="@annotation(log)")
    public Object around(ProceedingJoinPoint joinPoint, top.lshaci.framework.log.annotation.Log log) throws Throwable {
        LogModel logModel = new LogModel();
        try {
            this.fill(joinPoint, log, logModel);
            Object result = joinPoint.proceed();
            logModel.setStatus(OperateStatus.success);
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            logModel.setStatus(OperateStatus.failure).setExceptionMessage(e.getMessage());
            throw e;
        }
        finally {
            this.handle(logModel);
        }
    }

    private void fill(ProceedingJoinPoint joinPoint, top.lshaci.framework.log.annotation.Log log, LogModel logModel) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        logModel.setModule(log.module()).setTitle(log.title()).setTargetClass(targetMethod.getDeclaringClass()).setTargetMethod(targetMethod.getName()).setArgs(joinPoint.getArgs());
    }

    private void handle(LogModel logModel) {
        try {
            Object content = LogThreadLocal.get(Object.class);
            logModel.setContent(content);
            this.logService.record(logModel);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25", new Object[0]);
        }
        finally {
            LogThreadLocal.remove();
        }
    }

    public LogAspect(LogService logService) {
        this.logService = logService;
    }
}

