/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.log.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.log.aspect.LogAspect;
import top.lshaci.framework.log.service.LogService;
import top.lshaci.framework.log.service.impl.LoggingService;

@Configuration
@ConditionalOnProperty(value={"framework.log.enabled"}, matchIfMissing=true)
public class FrameworkLogConfig
implements BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(FrameworkLogConfig.class);
    private DefaultListableBeanFactory beanFactory;

    @Bean
    public LogAspect logAspect() {
        log.debug("Config log aspect...");
        return (LogAspect)this.beanFactory.createBean(LogAspect.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public LogService logService() {
        log.debug("Config logging service...");
        return new LoggingService();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }
}

