/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.log.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.log.enums.OperateStatus;
import top.lshaci.framework.log.model.LogModel;
import top.lshaci.framework.log.service.LogService;

public class LoggingService
implements LogService {
    private static final Logger log = LoggerFactory.getLogger(LoggingService.class);

    @Override
    public void record(LogModel model) {
        OperateStatus status = model.getStatus();
        Object content = model.getContent();
        if (OperateStatus.failure.equals((Object)status)) {
            log.warn("Execution failure ==> {}:{} - Module: {}, Title: {}, Content: {}, Exception message: {}.", new Object[]{model.getTargetClass().getName(), model.getTargetMethod(), model.getModule(), model.getTitle(), content, model.getExceptionMessage()});
        } else if (OperateStatus.success.equals((Object)status)) {
            log.debug("Execution success ==> {}:{} - Module: {}, Title: {}, Content: {}.", new Object[]{model.getTargetClass().getName(), model.getTargetMethod(), model.getModule(), model.getTitle(), content});
        }
    }
}

