/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.config;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import top.lshaci.framework.mybatis.datasource.DynamicDataSource;

@Configuration
public class MybatisConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisConfig.class);
    @Value(value="${mybatis.type-aliases-package}")
    private String mybatisTypeAliasesPackage;
    @Value(value="${mybatis.mapper-locations}")
    private String mybatisMapperLocations;

    @ConditionalOnProperty(value={"datasource.dynamic"}, matchIfMissing=false)
    @Bean
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="dataSource") DynamicDataSource dataSource) throws Exception {
        log.info("Init Mybatis Sql Session Factory...");
        SqlSessionFactoryBean sqlSessionFactory = new SqlSessionFactoryBean();
        sqlSessionFactory.setDataSource((DataSource)((Object)dataSource));
        sqlSessionFactory.setTypeAliasesPackage(this.mybatisTypeAliasesPackage);
        sqlSessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(this.mybatisMapperLocations));
        return sqlSessionFactory.getObject();
    }
}

