/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.config;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import top.lshaci.framework.mybatis.datasource.DynamicDataSource;
import top.lshaci.framework.mybatis.datasource.DynamicDataSourceType;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:datasource_single.properties"}), @PropertySource(value={"classpath:datasource_first.properties"}), @PropertySource(value={"classpath:datasource_second.properties"})})
public class DataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfig.class);

    @ConditionalOnProperty(value={"datasource.single"}, matchIfMissing=false)
    @Bean(name={"dataSource"})
    @ConfigurationProperties(value="datasource")
    public DataSource singleDataSource() {
        log.info("Init Single Druid DataSource...");
        return new DruidDataSource();
    }

    @ConditionalOnProperty(value={"datasource.dynamic", "datasource.first.url"}, matchIfMissing=false)
    @Bean(name={"firstDataSource"})
    @ConfigurationProperties(value="datasource.first")
    public DataSource firstDataSource() {
        log.info("Init First Druid DataSource...");
        return new DruidDataSource();
    }

    @ConditionalOnProperty(value={"datasource.dynamic", "datasource.second.url"}, matchIfMissing=false)
    @Bean(name={"secondDataSource"})
    @ConfigurationProperties(value="datasource.second")
    public DataSource secondDataSource() {
        log.info("Init Second Druid DataSource...");
        return new DruidDataSource();
    }

    @ConditionalOnProperty(value={"datasource.dynamic"}, matchIfMissing=false)
    @Bean(name={"dataSource"})
    @Primary
    public DynamicDataSource dynamicDataSource() {
        log.info("Init Dynamic Druid DataSource...");
        DynamicDataSource dataSource = new DynamicDataSource();
        HashMap<DynamicDataSourceType, DataSource> targetDataSources = new HashMap<DynamicDataSourceType, DataSource>();
        targetDataSources.put(DynamicDataSourceType.FIRST, this.firstDataSource());
        targetDataSources.put(DynamicDataSourceType.SECOND, this.secondDataSource());
        dataSource.setTargetDataSources(targetDataSources);
        dataSource.setDefaultTargetDataSource(this.firstDataSource());
        return dataSource;
    }

    @ConditionalOnProperty(value={"datasource.dynamic"}, matchIfMissing=false)
    @Bean
    public DataSourceTransactionManager transactionManager() {
        log.info("Init Data Source Transaction Manager...");
        return new DataSourceTransactionManager((DataSource)((Object)this.dynamicDataSource()));
    }
}

