/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.datasource;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.lshaci.framework.mybatis.datasource.DynamicDataSourceContextHolder;
import top.lshaci.framework.mybatis.datasource.DynamicDataSourceType;
import top.lshaci.framework.mybatis.datasource.TargetDataSource;

@Aspect
@Order(value=-10)
@Component
public class DynamicDataSourceAspect {
    @Before(value="@annotation(targetDataSource)")
    public void changeDataSource(JoinPoint point, TargetDataSource targetDataSource) {
        DynamicDataSourceType dataSourceType = targetDataSource.value();
        DynamicDataSourceContextHolder.setDataSourceType(dataSourceType);
    }

    @After(value="@annotation(targetDataSource)")
    public void restoreDataSource(JoinPoint point, TargetDataSource targetDataSource) {
        DynamicDataSourceContextHolder.clearDataSourceType();
    }
}

