/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.model;

import com.github.pagehelper.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PageResult<T>
implements Serializable {
    private static final long serialVersionUID = 2696109518770817050L;
    private int pgCt;
    private int pgSz;
    private int end;
    private int total;
    private List<T> datas = new ArrayList<T>();

    public PageResult(int pgCt, int pgSz) {
        this(pgCt, pgSz, 0);
    }

    public PageResult(int pgCt, int pgSz, int total) {
        this.pgCt = pgCt < 1 ? 1 : pgCt;
        this.pgSz = pgSz < 1 ? 10 : pgSz;
        this.total = total;
        this.end = (total + pgSz - 1) / pgSz;
    }

    public PageResult(int pgCt, int pgSz, int total, List<T> datas) {
        this(pgCt, pgSz, total);
        this.datas = datas;
    }

    public PageResult(Page<T> page) {
        Objects.requireNonNull(page, "Page result must not be null!");
        this.pgCt = page.getPageNum();
        this.pgSz = page.getPageSize();
        this.total = (int)page.getTotal();
        this.datas = page.getResult();
        this.end = page.getPages();
    }

    public int getPgCt() {
        return this.pgCt;
    }

    public int getPgSz() {
        return this.pgSz;
    }

    public int getEnd() {
        return this.end;
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }
}

