/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.config;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import top.lshaci.framework.mybatis.config.DynamicDataSourceConfig;
import top.lshaci.framework.mybatis.datasource.DynamicDataSource;

@Configuration
@AutoConfigureAfter(value={DynamicDataSourceConfig.class})
@PropertySource(value={"classpath:mybatis.properties"})
@ConditionalOnProperty(value={"datasource.dynamic"}, havingValue="true")
public class MybatisConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisConfig.class);
    @Value(value="${mybatis.type-aliases-package}")
    private String mybatisTypeAliasesPackage;
    @Value(value="${mybatis.mapper-locations}")
    private String mybatisMapperLocations;

    @Bean
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="dataSource") DynamicDataSource dataSource) throws Exception {
        log.debug("Init Mybatis Sql Session Factory...");
        SqlSessionFactoryBean sqlSessionFactory = new SqlSessionFactoryBean();
        sqlSessionFactory.setDataSource((DataSource)((Object)dataSource));
        sqlSessionFactory.setTypeAliasesPackage(this.mybatisTypeAliasesPackage);
        sqlSessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(this.mybatisMapperLocations));
        return sqlSessionFactory.getObject();
    }
}

