/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.config;

import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.mybatis.enabled.pagination"}, havingValue="true", matchIfMissing=true)
    public PaginationInterceptor paginationInterceptor() {
        log.debug("Config mybatis plus pagination interceptor.");
        return new PaginationInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.mybatis.enabled.optimistic-locker"}, havingValue="true")
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        log.debug("Config mybatis plus optimistic locker interceptor.");
        return new OptimisticLockerInterceptor();
    }
}

