/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.config;

import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.mybatis.properties.FrameworkMybatisProperties;

@Configuration
@EnableConfigurationProperties(value={FrameworkMybatisProperties.class})
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);
    @Autowired
    private FrameworkMybatisProperties properties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.mybatis.pagination.enabled"}, havingValue="true", matchIfMissing=true)
    public PaginationInterceptor paginationInterceptor() {
        log.debug("Config mybatis plus pagination interceptor.");
        PaginationInterceptor interceptor = new PaginationInterceptor();
        interceptor.setLimit(this.properties.getPagination().getLimit());
        interceptor.setOverflow(this.properties.getPagination().isOverflow());
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"framework.mybatis.optimistic-locker.enabled"}, havingValue="true", matchIfMissing=true)
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        log.debug("Config mybatis plus optimistic locker interceptor.");
        return new OptimisticLockerInterceptor();
    }
}

