/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.config;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.mybatis.properties.FrameworkMybatisProperties;

@Configuration
@EnableConfigurationProperties(value={FrameworkMybatisProperties.class})
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);
    private final FrameworkMybatisProperties properties;

    @Bean
    public MybatisPlusInterceptor MybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (this.properties.getPagination().isEnabled()) {
            log.debug("Config mybatis plus pagination interceptor.");
            PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
            paginationInnerInterceptor.setMaxLimit(Long.valueOf(this.properties.getPagination().getLimit()));
            paginationInnerInterceptor.setOverflow(this.properties.getPagination().isOverflow());
            interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        }
        if (this.properties.getOptimisticLocker().isEnabled()) {
            log.debug("Config mybatis plus optimistic locker interceptor.");
            interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        }
        return interceptor;
    }

    public MybatisPlusConfig(FrameworkMybatisProperties properties) {
        this.properties = properties;
    }
}

