/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.mybatis.utils;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Objects;
import top.lshaci.framework.common.model.PageQuery;

public class PageUtils {
    public static <T> Page<T> of(PageQuery pageQuery) {
        return PageUtils.of(pageQuery.getPgCt().intValue(), pageQuery.getPgSz().intValue());
    }

    public static <T> Page<T> of(PageQuery pageQuery, boolean searchCountOnlyFirstPage) {
        Integer pgCt = pageQuery.getPgCt();
        Integer pgSz = pageQuery.getPgSz();
        if (searchCountOnlyFirstPage) {
            return PageUtils.of(pgCt.intValue(), pgSz.intValue(), Objects.equals(pgCt, 1));
        }
        return PageUtils.of(pgCt.intValue(), pgSz.intValue());
    }

    public static <T> Page<T> of(long pgCt, long pgSz) {
        return PageUtils.of(pgCt, pgSz, true);
    }

    public static <T> Page<T> of(long pgCt, long pgSz, boolean searchCount) {
        return new Page(pgCt, pgSz, searchCount);
    }
}

