/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.pdfUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;
import top.lshaci.framework.common.exception.BaseException;

public class ItextPdfUtils {
    private static final Logger log = LoggerFactory.getLogger(ItextPdfUtils.class);
    private static final String SIMSUN_NAME = "simsun.ttc";
    private static final String FONT_PATH = "fonts/";

    public static ByteArrayOutputStream export(String htmlStr) {
        return ItextPdfUtils.export(htmlStr, "./font");
    }

    public static void export(String htmlStr, OutputStream os) {
        ItextPdfUtils.export(htmlStr, "./font", os);
    }

    public static ByteArrayOutputStream export(String htmlStr, String fontPath) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ItextPdfUtils.export(htmlStr, fontPath, os);
        return os;
    }

    public static void export(String htmlStr, String fontPath, OutputStream os) {
        try (OutputStream os_ = os;){
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocumentFromString(htmlStr);
            ITextFontResolver fontResolver = renderer.getFontResolver();
            String sysPath = ItextPdfUtils.createSimsunFont(fontPath);
            if ("linux".equals(ItextPdfUtils.getCurrentOperatingSystem())) {
                fontResolver.addFont(sysPath, "Identity-H", true);
            } else {
                fontResolver.addFont(sysPath, "Identity-H", false);
            }
            renderer.layout();
            renderer.createPDF(os_, true);
        }
        catch (Exception e) {
            log.error("Error exporting PDF!", (Throwable)e);
            throw new BaseException("Error exporting PDF!", (Throwable)e);
        }
    }

    private static String createSimsunFont(String fontPath) {
        String sysPath = fontPath + File.separator + SIMSUN_NAME;
        File fontFile = new File(sysPath);
        if (!fontFile.exists()) {
            log.info("Simsun font not exist. Create it.");
            String simsunPath = "fonts/simsun.ttc";
            log.info("The simsun font path is: " + simsunPath);
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(simsunPath);){
                int ch;
                fontFile.getParentFile().mkdirs();
                FileOutputStream fontFileOs = new FileOutputStream(fontFile);
                byte[] buffer = new byte[4096];
                while ((ch = stream.read(buffer)) != -1) {
                    ((OutputStream)fontFileOs).write(buffer, 0, ch);
                }
                fontFileOs.flush();
                ((OutputStream)fontFileOs).close();
            }
            catch (Exception e) {
                log.error("Create font failure.", (Throwable)e);
                throw new BaseException("Create font failure.", (Throwable)e);
            }
        }
        return sysPath;
    }

    private static String getCurrentOperatingSystem() {
        return System.getProperty("os.name").toLowerCase();
    }
}

