package top.lshaci.framework.pdf.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * PdfErrorInfo
 *
 * @author lshaci
 * @since 1.0.9
 */
@Getter
@AllArgsConstructor
public enum PdfErrorInfo implements ErrorInfo {

    /**
     * create_font_failure
     */
    create_font_failure(503_0_01, "创建字体失败"),
    /**
     * export_failure
     */
    export_failure(503_0_02, "导出PDF失败"),
    ;

    /**
     * 异常码
     */
    private final int code;
    /**
     * 异常信息
     */
    private final String msg;

}
