/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.redis.lock;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import top.lshaci.framework.redis.lock.locker.Locker;
import top.lshaci.framework.redis.lock.model.DistributedRollBack;
import top.lshaci.framework.redis.lock.model.DistributedTask;
import top.lshaci.framework.redis.lock.model.DistributedTaskResult;
import top.lshaci.framework.redis.utils.ExecutorUtils;

public class RedisDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private static final int DEFAULT_RETRY_COUNT = 1;
    private static final long DEFAULT_EXPIRE_TIME = 5000L;
    private static final long DEFAULT_DELAY_TIME = 100L;
    private static final String FAILURE_MSG_HAS_ROLLBACK = "The distributed task execution failed, and the exception rollback was executed.";
    private static final String FAILURE_MSG_NO_BOLLBACK = "Distributed task execution failed, no abnormal rollback.";
    private static final String FAILURE_MSG_NO_GET_LOCK = "The distributed task is not executed, and the lock is not acquired.";
    private static final String NOT_FETCH_LOCK_MSG = "Not fetch lock for key={} retryCount={} delayTime(ms)={}.";
    private static final String TASK_BEGIN_MSG = "Distributed task execution begins. The source key is: {}.";
    private static final String TASK_END_MSG = "Distributed task execution complete. The source key is: {}.";
    private int retryCount;
    private long expireTime;
    private long delayTime;
    private Locker locker;

    public RedisDistributedLock(Locker locker) {
        this.locker = locker;
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key) {
        return this.execute(task, key, 1);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount) {
        return this.execute(task, key, retryCount, 5000L);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, DistributedRollBack rollBack) {
        return this.execute(task, key, 1, rollBack, true);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, DistributedRollBack rollBack, boolean isAsync) {
        return this.execute(task, key, 1, rollBack, isAsync);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount, long expireTime) {
        return this.execute(task, key, retryCount, expireTime, null);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount, DistributedRollBack rollBack) {
        return this.execute(task, key, retryCount, rollBack, true);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount, DistributedRollBack rollBack, boolean isAsync) {
        return this.execute(task, key, retryCount, 100L, 5000L, rollBack, isAsync);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount, long expireTime, DistributedRollBack rollBack) {
        return this.execute(task, key, retryCount, expireTime, rollBack, true);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount, long expireTime, DistributedRollBack rollBack, boolean isAsync) {
        return this.execute(task, key, retryCount, 100L, expireTime, rollBack, isAsync);
    }

    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount, long delayTime, long expireTime, DistributedRollBack rollBack) {
        return this.execute(task, key, retryCount, delayTime, expireTime, rollBack, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> DistributedTaskResult<R> execute(DistributedTask<R> task, String key, int retryCount, long delayTime, long expireTime, DistributedRollBack rollBack, boolean isAsync) {
        this.checkParameter(task, key, retryCount, delayTime, expireTime);
        try {
            String lockKey = "lock:" + key;
            long getLock = 0L;
            while (getLock == 0L && (retryCount == -1 || retryCount-- > 0)) {
                getLock = this.getLock(lockKey, expireTime);
                if (getLock > 0L) {
                    try {
                        log.debug(TASK_BEGIN_MSG, (Object)key);
                        R data = task.run();
                        log.debug(TASK_END_MSG, (Object)key);
                        DistributedTaskResult<R> distributedTaskResult = new DistributedTaskResult<R>(data);
                        return distributedTaskResult;
                    }
                    catch (Exception ex) {
                        log.error("Failed to perform distributed task!", (Throwable)ex);
                        String message = this.rollBack(rollBack, isAsync);
                        DistributedTaskResult distributedTaskResult = new DistributedTaskResult(message, ex);
                        return distributedTaskResult;
                    }
                    finally {
                        this.locker.unLock(lockKey, getLock);
                    }
                }
                Thread.sleep(delayTime);
            }
            log.warn(NOT_FETCH_LOCK_MSG, new Object[]{key, retryCount, delayTime});
            return new DistributedTaskResult(FAILURE_MSG_NO_GET_LOCK);
        }
        catch (Exception e) {
            log.error("Performing a distributed task is an exception!", (Throwable)e);
            String message = this.rollBack(rollBack, isAsync);
            return new DistributedTaskResult(message, e);
        }
    }

    private long getLock(String key, long expiredTime) {
        try {
            return this.locker.tryLock(key, expiredTime);
        }
        catch (Exception e) {
            log.error("Try to get Lock Exception!", (Throwable)e);
            return 0L;
        }
    }

    private <R> void checkParameter(DistributedTask<R> task, String key, int retryCount, long delayTime, long expireTime) {
        Assert.notNull(task, (String)"The distributed task must not be null!");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"The resource key must not be blank!");
        Assert.isTrue((retryCount > 0 || retryCount == -1 ? 1 : 0) != 0, (String)"The retry count must be greater than zero or equals -1!");
        Assert.isTrue((delayTime > 0L ? 1 : 0) != 0, (String)"The delay time must be greater than zero!");
        Assert.isTrue((expireTime > 0L ? 1 : 0) != 0, (String)"The expired time must be greater than zero!");
    }

    private String rollBack(DistributedRollBack rollBack, boolean isAsync) {
        if (rollBack != null) {
            log.info("Start rolling back.");
            if (isAsync) {
                ExecutorUtils.execute(() -> rollBack.rollBack());
            } else {
                rollBack.rollBack();
                log.info("Perform synchronous rollback completion.");
            }
            return FAILURE_MSG_HAS_ROLLBACK;
        }
        return FAILURE_MSG_NO_BOLLBACK;
    }

    public void setDefaultRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setDefaultExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public void setDefaultDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public Locker getLocker() {
        return this.locker;
    }
}

