/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.redis.lock.locker;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import top.lshaci.framework.redis.lock.locker.Locker;

public class RedisLocker
implements Locker {
    private static final Logger log = LoggerFactory.getLogger(RedisLocker.class);
    private static final long DEFAULT_EXPIRE_TIME = 5000L;
    private long expireTime;
    private RedisTemplate<Object, Object> redisTemplate;

    public RedisLocker(RedisTemplate<Object, Object> redisTemplate) {
        Objects.requireNonNull(redisTemplate, "Redis template must not be null!");
        this.redisTemplate = redisTemplate;
    }

    @Override
    public long tryLock(String lockKey) {
        return this.tryLock(lockKey, 5000L);
    }

    @Override
    public synchronized long tryLock(final String lockKey, long lockExpireTime) {
        final long expireTime = this.redisCurrentTime() + lockExpireTime + 1L;
        if (((Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                JdkSerializationRedisSerializer jdkSerializer = new JdkSerializationRedisSerializer();
                byte[] value = jdkSerializer.serialize((Object)expireTime);
                return connection.setNX(lockKey.getBytes(), value);
            }
        })).booleanValue()) {
            log.info("Get lock, the lock key is: " + lockKey);
            this.redisTemplate.expire((Object)lockKey, lockExpireTime, TimeUnit.MILLISECONDS);
            return expireTime;
        }
        Long currentLockTime = (Long)this.redisTemplate.opsForValue().get((Object)lockKey);
        if (currentLockTime == null || this.redisCurrentTime() > currentLockTime) {
            long newExpireTime = this.redisCurrentTime() + lockExpireTime + 1L;
            Long oldLockTimeout = (Long)this.redisTemplate.opsForValue().getAndSet((Object)lockKey, (Object)newExpireTime);
            if (oldLockTimeout == null || this.redisCurrentTime() > oldLockTimeout) {
                log.info("Get lock, the lock key is: " + lockKey);
                this.redisTemplate.expire((Object)lockKey, lockExpireTime, TimeUnit.MILLISECONDS);
                return newExpireTime;
            }
        }
        log.warn("Not get lock, the lock key is: " + lockKey);
        return 0L;
    }

    @Override
    public void unLock(String lockKey, long lockReleaseTime) {
        if (this.redisCurrentTime() > lockReleaseTime) {
            log.info("Unlock success, the lock has been released automatically.");
            return;
        }
        Long currentLockTime = (Long)this.redisTemplate.opsForValue().get((Object)lockKey);
        if (currentLockTime != null && currentLockTime > this.redisCurrentTime()) {
            this.redisTemplate.delete((Object)lockKey);
            log.info("Unlock success, the lock has been released.");
        }
    }

    private long redisCurrentTime() {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.time();
            }
        });
    }

    public void setDefaultExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public RedisTemplate<Object, Object> getRedisTemplate() {
        return this.redisTemplate;
    }
}

