/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.redis.config;

import com.alibaba.fastjson.support.spring.GenericFastJsonRedisSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import top.lshaci.framework.redis.properties.FrameworkRedisProperties;
import top.lshaci.framework.redis.utils.RedisId;

@Configuration
@EnableConfigurationProperties(value={FrameworkRedisProperties.class})
public class FrameworkRedisConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkRedisConfig.class);
    private final FrameworkRedisProperties properties;

    @Bean
    public GenericFastJsonRedisSerializer valueSerializer() {
        log.debug("Config generic fast json redis serializer...");
        return new GenericFastJsonRedisSerializer();
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        log.debug("Config RedisTemplate<String, Object>...");
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)StringRedisSerializer.UTF_8);
        template.setDefaultSerializer((RedisSerializer)this.valueSerializer());
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    public RedisId redisId() {
        log.debug("Config RedisId...");
        RedisId redisId = new RedisId();
        redisId.setSerialLength(this.properties.getSerialLength());
        return redisId;
    }

    public FrameworkRedisConfig(FrameworkRedisProperties properties) {
        this.properties = properties;
    }
}

