/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.redis.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import top.lshaci.framework.common.exception.BaseException;

public class RedisId {
    private static int serialLength;
    private static RedisTemplate<String, Object> redisTemplate;
    private static final String defaultPrefix = "REDIS_ID:";
    private static final ZoneId ZONE;

    public static String next(String prefix) {
        return RedisId.next(prefix, serialLength);
    }

    public static String next(String prefix, int serialLength) {
        String now = LocalDate.now().toString().replace("-", "");
        String key = prefix + now;
        String id = RedisId.redisNext(key, serialLength);
        return key + id;
    }

    public static String next() {
        return RedisId.next(serialLength);
    }

    public static String next(int serialLength) {
        String now = LocalDate.now().toString().replace("-", "");
        String key = defaultPrefix + now;
        String id = RedisId.redisNext(key, serialLength);
        return now + id;
    }

    private static String redisNext(String key, int serialLength) {
        Long id = redisTemplate.opsForValue().increment((Object)key);
        if (Objects.isNull(id)) {
            throw new BaseException("\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25");
        }
        redisTemplate.expireAt((Object)key, RedisId.nextDate());
        return StringUtils.leftPad((String)id.toString(), (int)serialLength, (String)"0");
    }

    private static Date nextDate() {
        LocalDateTime localDateTime = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(5);
        Instant instant = localDateTime.atZone(ZONE).toInstant();
        return Date.from(instant);
    }

    public void setSerialLength(int serialLength) {
        RedisId.serialLength = serialLength;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisId.redisTemplate = redisTemplate;
    }

    static {
        ZONE = ZoneId.systemDefault();
    }
}

