package top.lshaci.framework.redis.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * RedisErrorInfo
 *
 * @author lshaci
 * @since 1.1.0
 */
@Getter
@AllArgsConstructor
public enum RedisErrorInfo implements ErrorInfo {
    /**
     * serial number generate failure
     */
    serial_number_generate_failure(504_0_01, "流水号生成失败");

    /**
     * 异常码
     */
    private final int code;
    /**
     * 异常信息
     */
    private final String msg;
}
