/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.redis.utils;

import cn.hutool.core.util.StrUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import top.lshaci.framework.redis.enums.RedisErrorInfo;
import top.lshaci.framework.redis.exception.RedisException;

public class RedisId {
    private static int serialLength;
    private static RedisTemplate<String, Object> redisTemplate;
    private static final String defaultPrefix = "REDIS_ID:";
    private static final ZoneId ZONE;

    public static String next(String prefix) {
        return RedisId.next(prefix, serialLength);
    }

    public static String next(String prefix, int serialLength) {
        String now = LocalDate.now().toString().replace("-", "");
        String key = prefix + now;
        String id = RedisId.redisNext(key, serialLength);
        return key + id;
    }

    public static String next() {
        return RedisId.next(serialLength);
    }

    public static String next(int serialLength) {
        String now = LocalDate.now().toString().replace("-", "");
        String key = defaultPrefix + now;
        String id = RedisId.redisNext(key, serialLength);
        return now + id;
    }

    public static String redisNext(String key, int serialLength) {
        Long id = redisTemplate.opsForValue().increment((Object)key);
        if (Objects.isNull(id)) {
            throw new RedisException(RedisErrorInfo.serial_number_generate_failure, new Object[0]);
        }
        redisTemplate.expireAt((Object)key, RedisId.nextDate());
        String idStr = String.valueOf(id);
        return idStr.length() > serialLength ? idStr : StrUtil.padPre((CharSequence)idStr, (int)serialLength, (char)'0');
    }

    private static Date nextDate() {
        LocalDateTime localDateTime = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(1);
        Instant instant = localDateTime.atZone(ZONE).toInstant();
        return Date.from(instant);
    }

    public void setSerialLength(int serialLength) {
        RedisId.serialLength = serialLength;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisId.redisTemplate = redisTemplate;
    }

    static {
        ZONE = ZoneId.systemDefault();
    }
}

