/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.swagger.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@PropertySource(value={"classpath:swagger.properties"})
public class SwaggerConfig {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfig.class);
    @Value(value="${swagger.basePackage}")
    private String basePackage;
    @Value(value="${swagger.title}")
    private String title;
    @Value(value="${swagger.description}")
    private String description;
    @Value(value="${swagger.serviceUrl}")
    private String serviceUrl;
    @Value(value="${swagger.version}")
    private String version;
    @Value(value="${swagger.contact.name}")
    private String contactName;
    @Value(value="${swagger.contact.url}")
    private String contactUrl;
    @Value(value="${swagger.contact.email}")
    private String contactEmail;

    @Bean
    public Docket createRestApi() throws Exception {
        log.info("Init Swagger UI Config...");
        if (StringUtils.isEmpty((Object)this.basePackage)) {
            throw new Exception("The controller base package must not be null!");
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.basePackage)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title).description(this.description).termsOfServiceUrl(this.serviceUrl).contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).version(this.version).build();
    }
}

