/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.swagger.autoconfigure;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import top.lshaci.framework.swagger.properties.SwaggerProperties;

@Configuration
@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnProperty(prefix="spring.swagger", value={"enabled"}, havingValue="true")
public class SwaggerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    @Autowired
    private SwaggerProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public Docket docket() throws Exception {
        log.debug("Init Swagger UI Config...");
        if (StringUtils.isEmpty((Object)this.properties.getBasePackage())) {
            throw new Exception("The controller base package must not be null!");
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).directModelSubstitute(Byte.class, Integer.class).select().apis(RequestHandlerSelectors.basePackage((String)this.properties.getBasePackage())).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).termsOfServiceUrl(this.properties.getServiceUrl()).contact(this.properties.getContact().get()).version(this.properties.getVersion()).build();
    }
}

